/*
 * Decompiled with CFR 0.152.
 */
package jade.imtp.leap.JICP;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;

public class JICPCompressor1 {
    private static final int WORD_MAGIC = 200;
    private static final int RLE_MAGIC = 201;
    private static final int MAX_WORDS = 254;
    private static final int RLE_FLUSH = 256;
    private int rleOldValue = 256;
    private int rleOccurrence = 0;
    private byte[] ba;

    private static boolean isSep(int value) {
        return !(value >= 65 && value <= 90 || value >= 97 && value <= 122 || value >= 48 && value <= 57 || value == 45 || value == 95);
    }

    private void rleWrite(ByteArrayOutputStream baos, int value) {
        if (this.rleOldValue == 256) {
            this.rleOldValue = value;
            this.rleOccurrence = 1;
            return;
        }
        if (value != this.rleOldValue || this.rleOccurrence == 255) {
            if (this.rleOldValue == 201 || this.rleOccurrence > 2) {
                baos.write(201);
                baos.write(this.rleOccurrence);
                if (this.rleOccurrence > 2) {
                    baos.write(this.rleOldValue);
                }
            } else {
                int i = 0;
                while (i < this.rleOccurrence) {
                    baos.write(this.rleOldValue);
                    ++i;
                }
            }
            this.rleOccurrence = 0;
        }
        ++this.rleOccurrence;
        this.rleOldValue = value;
    }

    private int rleRead(ByteArrayInputStream bais) {
        if (this.rleOccurrence == 0) {
            this.rleOldValue = bais.read();
            if (this.rleOldValue == 201) {
                this.rleOccurrence = bais.read();
                if (this.rleOccurrence > 2) {
                    this.rleOldValue = bais.read();
                }
            } else {
                this.rleOccurrence = 1;
            }
        }
        --this.rleOccurrence;
        return this.rleOldValue;
    }

    private int getValue(int index) {
        return index >= this.ba.length ? 256 : (char)this.ba[index] & 0xFF;
    }

    private void setValue(int index, int value) {
        if (index >= this.ba.length) {
            byte[] newba = new byte[index * 5 / 4 + 1];
            System.arraycopy(this.ba, 0, newba, 0, this.ba.length);
            this.ba = newba;
        }
        this.ba[index] = (byte)value;
    }

    public static byte[] compress(byte[] ba) {
        if (ba == null) {
            return null;
        }
        return new JICPCompressor1().compressHelper(ba);
    }

    private byte[] compressHelper(byte[] uba) {
        int[] wordIndexes = new int[254];
        int beginIndex = 0;
        int wordIndex = 0;
        int lastWordIndex = 0;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.ba = uba;
        int i = 0;
        while (i <= this.ba.length) {
            if (JICPCompressor1.isSep(this.getValue(i))) {
                boolean foundWord = false;
                if (i - beginIndex > 2) {
                    int wi = 0;
                    while (wi < lastWordIndex) {
                        int ch2;
                        int ch1;
                        int existingWordIndex = wordIndexes[wi];
                        int j = 0;
                        while ((ch1 = this.getValue(existingWordIndex + j)) == (ch2 = this.getValue(beginIndex + j))) {
                            if (JICPCompressor1.isSep(ch1) && JICPCompressor1.isSep(ch2)) {
                                foundWord = true;
                                break;
                            }
                            ++j;
                        }
                        if (foundWord) {
                            this.rleWrite(baos, 200);
                            this.rleWrite(baos, wi);
                            this.rleWrite(baos, this.getValue(i));
                            break;
                        }
                        ++wi;
                    }
                    if (!foundWord) {
                        if (wordIndex == 254) {
                            wordIndex = 0;
                        }
                        wordIndexes[wordIndex++] = beginIndex;
                        if (wordIndex > lastWordIndex) {
                            lastWordIndex = wordIndex;
                        }
                    }
                }
                if (!foundWord) {
                    int j = beginIndex;
                    while (j <= i) {
                        int ch = this.getValue(j);
                        this.rleWrite(baos, ch);
                        if (ch == 200) {
                            this.rleWrite(baos, 255);
                        }
                        ++j;
                    }
                }
                beginIndex = i + 1;
            }
            ++i;
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] decompress(byte[] cba) {
        if (cba == null) {
            return null;
        }
        return new JICPCompressor1().decompressHelper(cba);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] decompressHelper(byte[] cba) {
        int ch;
        int[] wordIndexes = new int[254];
        int wordIndex = 0;
        int currentIndex = 0;
        int beginIndex = 0;
        ByteArrayInputStream bais = new ByteArrayInputStream(cba);
        this.ba = new byte[cba.length * 3 / 2];
        while ((ch = this.rleRead(bais)) != -1) {
            void var7_7;
            if (var7_7 == 200) {
                int wi = this.rleRead(bais);
                if (wi == 255) {
                    this.setValue(currentIndex++, -56);
                } else {
                    int refWordIndex = wordIndexes[wi];
                    while (!JICPCompressor1.isSep(this.ba[refWordIndex])) {
                        this.setValue(currentIndex++, this.ba[refWordIndex++]);
                    }
                }
                beginIndex = currentIndex + 1;
                continue;
            }
            if (JICPCompressor1.isSep((byte)var7_7)) {
                if (currentIndex - beginIndex > 2) {
                    if (wordIndex == 254) {
                        wordIndex = 0;
                    }
                    wordIndexes[wordIndex++] = beginIndex;
                }
                beginIndex = currentIndex + 1;
            }
            this.setValue(currentIndex++, (byte)var7_7);
        }
        byte[] newba = new byte[currentIndex];
        System.arraycopy(this.ba, 0, newba, 0, currentIndex);
        System.out.println("dec " + cba.length + "->" + currentIndex);
        return newba;
    }
}

